/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.BetterFish;
import dangerzone.entities.Entity;
import dangerzone.entities.TheCount;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Mermaid
extends BetterFish {
    public Mermaid(World w) {
        super(w);
        this.width = 0.65f;
        this.height = 1.75f;
        this.uniquename = "DangerZone:Mermaid";
        this.has_inventory = true;
        this.setMaxHealth(70.0f);
        this.setHealth(70.0f);
        this.setDefense(1.5f);
        this.setAttackDamage(10.0f);
        this.setExperience(80);
        this.setMaxAir(40.0f);
        this.setAir(40.0f);
        this.searchDistance = 30.0f;
        this.attackRange = 3.0f;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = true;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = true;
        this.tower_defense_enable = false;
        this.moveSpeed = 0.28f;
        this.enable_buddy = true;
        this.findbuddyfrequency = 35;
        this.findbuddydistance = 24;
    }

    @Override
    public boolean isBuddy(Entity e) {
        return e instanceof Mermaid;
    }

    @Override
    public void init() {
        super.init();
        if (this.world != null && this.world.isServer && this.getInitialized() == 0) {
            this.setInitialized(1);
            InventoryContainer ic = new InventoryContainer();
            if (this.world.rand.nextInt(6) == 0) {
                ic = new InventoryContainer();
                ic.iid = Items.tiara.itemID;
                ic.count = 1;
                ic.currentuses = this.world.rand.nextInt(ic.getItem().maxuses / 2);
                this.setArmor(0, ic);
            }
        }
    }

    @Override
    public void doEntityAction(float deltaT) {
        super.doEntityAction(deltaT);
        if (this.world.rand.nextInt(100) == 1) {
            this.heal(1.0f);
        }
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        int which = this.world.rand.nextInt(9);
        if (which == 0) {
            return "DangerZone:vixen_hurt1";
        }
        if (which == 1) {
            return "DangerZone:vixen_hurt2";
        }
        if (which == 2) {
            return "DangerZone:vixen_hurt3";
        }
        if (which == 3) {
            return "DangerZone:vixen_hurt4";
        }
        if (which == 4) {
            return "DangerZone:vixen_hurt5";
        }
        if (which == 5) {
            return "DangerZone:vixen_hurt6";
        }
        if (which == 6) {
            return "DangerZone:vixen_hurt7";
        }
        if (which == 7) {
            return "DangerZone:vixen_hurt8";
        }
        if (which == 8) {
            return "DangerZone:vixen_hurt9";
        }
        return null;
    }

    @Override
    public String getDeathSound() {
        return this.getHurtSound();
    }

    @Override
    public String getAttackSound() {
        return null;
    }

    @Override
    public void doDeathDrops() {
        super.doDeathDrops();
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophymermaid.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof TheCount) {
            return false;
        }
        if (e instanceof Mermaid) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            InventoryContainer ic = e.getArmor(0);
            return ic == null || ic.iid != Items.tiara.itemID;
        }
        return false;
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Mermaidtexture.png");
        }
        return this.texture;
    }
}

